/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatSet;
import oracle.install.commons.util.XmlSupport;
import org.xml.sax.InputSource;

public class XmlBeanStoreFormatRegistry {
    private static final Logger logger = Logger.getLogger(XmlBeanStoreFormatRegistry.class.getName());
    private static final XmlBeanStoreFormat DEFAULT_XML_BEAN_STORE_FORMAT = new XmlBeanStoreFormat();
    private static XmlBeanStoreFormatRegistry instance = null;
    private Map<String, XmlBeanStoreFormat> namespaceURIFormatMap = new HashMap<String, XmlBeanStoreFormat>();
    private Map<String, XmlBeanStoreFormatSet> fileExtFormatMap = new HashMap<String, XmlBeanStoreFormatSet>();
    private XmlBeanStoreFormat defaultFormat = DEFAULT_XML_BEAN_STORE_FORMAT;

    public static XmlBeanStoreFormatRegistry getInstance() {
        if (instance == null) {
            instance = new XmlBeanStoreFormatRegistry();
        }
        return instance;
    }

    protected XmlBeanStoreFormatRegistry() {
    }

    public XmlBeanStoreFormat getDefaultFormat() {
        return this.defaultFormat;
    }

    public void setDefaultFormat(XmlBeanStoreFormat defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public void addFormat(XmlBeanStoreFormat format, boolean asDefault) {
        if (format != null) {
            this.namespaceURIFormatMap.put(format.getNamespaceURI(), format);
            if (asDefault) {
                this.defaultFormat = format;
            }
        }
    }

    public void addFormat(XmlBeanStoreFormat format) {
        this.addFormat(format, false);
    }

    public void removeFormat(String namespaceURI) {
        this.namespaceURIFormatMap.remove(namespaceURI);
    }

    public void removeFormat(XmlBeanStoreFormat format) {
        if (format != null) {
            this.namespaceURIFormatMap.remove(format.getNamespaceURI());
        }
    }

    public XmlBeanStoreFormat getFormat(String namespaceURI) {
        return this.namespaceURIFormatMap.get(namespaceURI);
    }

    public XmlBeanStoreFormat getFormat(URL sourceURL) throws BeanStoreException {
        return this.getFormat(sourceURL, null);
    }

    public XmlBeanStoreFormat getFormat(URL sourceURL, String namespace) throws BeanStoreException {
        InputSource inputSource = null;
        if (sourceURL != null) {
            inputSource = new InputSource(sourceURL.toExternalForm());
        }
        return this.getFormat(inputSource);
    }

    public XmlBeanStoreFormat getFormat(InputSource inputSource) throws BeanStoreException {
        return this.getFormat(inputSource, null);
    }

    public XmlBeanStoreFormat getFormat(InputSource inputSource, String namespace) throws BeanStoreException {
        XmlBeanStoreFormat format = this.getDefaultFormat();
        if (inputSource != null) {
            namespace = namespace == null ? "ins" : namespace;
            try {
                String namespaceURI = XmlSupport.getNamespaceURI(inputSource, namespace);
                logger.log(Level.INFO, "namespace URI for namespace " + namespace + " is " + namespaceURI);
                if (namespaceURI != null) {
                    format = this.namespaceURIFormatMap.get(namespaceURI);
                }
            }
            catch (Exception e) {
                throw new BeanStoreException(e);
            }
        }
        return format;
    }

    public String[] getSupportFileExtensions() {
        return this.fileExtFormatMap.keySet().toArray(new String[0]);
    }

    public void registerFileFormatSet(String fileExtension, XmlBeanStoreFormatSet formatSet) {
        this.registerFileFormatSet(fileExtension, formatSet, false);
    }

    public void registerFileFormatSet(String fileExtension, XmlBeanStoreFormatSet formatSet, boolean asDefault) {
        this.fileExtFormatMap.put(fileExtension, formatSet);
        if (formatSet != null) {
            XmlBeanStoreFormat latestFormat;
            for (XmlBeanStoreFormat format : formatSet) {
                this.addFormat(format);
            }
            if (asDefault && (latestFormat = formatSet.getLatestFormat()) != null) {
                this.setDefaultFormat(latestFormat);
            }
        }
    }

    public void registerFileFormat(String fileExtension, XmlBeanStoreFormat format, boolean asDefault) {
        XmlBeanStoreFormatSet formatSet = this.fileExtFormatMap.get(fileExtension);
        if (formatSet == null) {
            formatSet = new XmlBeanStoreFormatSet(format, new XmlBeanStoreFormat[0]);
            this.fileExtFormatMap.put(fileExtension, formatSet);
        } else {
            formatSet.add(format);
        }
        this.addFormat(format, asDefault);
    }

    public void registerFileFormat(String fileExtension, XmlBeanStoreFormat format) {
        this.registerFileFormat(fileExtension, format, false);
    }

    public void unregisterFileFormat(String fileExtension) {
        XmlBeanStoreFormatSet formatSet = this.fileExtFormatMap.remove(fileExtension);
        if (formatSet != null) {
            for (XmlBeanStoreFormat format : formatSet) {
                this.removeFormat(format);
            }
        }
    }

    public boolean isBeanStoreFileValid(String extension) {
        return this.fileExtFormatMap.keySet().contains(extension);
    }

    public XmlBeanStoreFormatSet getAllFileFormat(String fileExtension) {
        return this.fileExtFormatMap.get(fileExtension);
    }

    public XmlBeanStoreFormat getFileFormat(String fileExtension) {
        XmlBeanStoreFormatSet formatSet = this.fileExtFormatMap.get(fileExtension);
        return formatSet != null ? formatSet.getLatestFormat() : null;
    }

    public XmlBeanStoreFormat getFileFormat(File beanStoreFile) throws Exception {
        String ext = this.getFileExtension(beanStoreFile);
        XmlBeanStoreFormat format = this.getFileFormat(ext);
        if (format != null) {
            format = format.getCompatibleFormat(new InputSource(beanStoreFile.toURL().toExternalForm()));
        }
        return format;
    }

    public boolean isBeanStoreFileSupported(File beanStoreFile) {
        boolean valid = false;
        if (beanStoreFile != null) {
            String ext = this.getFileExtension(beanStoreFile);
            valid = this.isBeanStoreFileValid(ext);
        }
        return valid;
    }

    private String getFileExtension(File beanStoreFile) {
        String ext = null;
        String name = beanStoreFile.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            ext = name.substring(dotIndex + 1);
        }
        return ext;
    }
}

